# Sum from 1..n — Iterative vs Recursive (Java)

## 1) Objective

Solve the problem of computing the sum of all integers from **1** to **n** using **two approaches**:

- **Iterative**: accumulate the sum in a loop.
- **Recursive**: express `sum(1..n)` in terms of a smaller instance `sum(1..n-1)`.

> Class demo reference: `sumIter(int n)` and `sumRec(int n)` from `Main`.

---

## 2) Tracing the recursive solution for n = 0, 1, 2

We use the definition implemented in class:

```java
long sumRec(int n) {
  if (n == 0) return 0;          // base case
  return n + sumRec(n - 1);      // recursive step
}
```

### n = 0

- Call: `sumRec(0)`
- Hits **base case** → returns **0** immediately.

### n = 1

- Call: `sumRec(1)`

  - Needs `1 + sumRec(0)`
  - `sumRec(0)` → base case → returns **0**
  - Total: **1 + 0 = 1**

### n = 2

- Call: `sumRec(2)`

  - Needs `2 + sumRec(1)`
  - `sumRec(1)` needs `1 + sumRec(0)`

    - `sumRec(0)` → base case → **0**
    - `sumRec(1)` returns **1 + 0 = 1**

  - `sumRec(2)` returns **2 + 1 = 3**

Call stack view for n = 2:

```
sumRec(2)
  → 2 + sumRec(1)
            → 1 + sumRec(0)
                      → 0
```

---

## 3) Time & Space Complexity

### Iterative (`sumIter`)

- **Time:** `O(n)` — one pass from 1 to n.
- **Space:** `O(1)` — constant extra memory.

### Recursive (`sumRec`)

- **Time:** `O(n)` — one recursive call per integer from n down to 0.
- **Space:** `O(n)` — call stack grows to depth `n` (no tail-call optimization in Java; this is **not** tail-recursive).
- **Practical note:** Very large `n` can cause a `StackOverflowError`.

---

## 4) Anatomy of a recursive solution (Reminder)

A good recursive method includes:

- **Base case**: a smallest/simplest input handled directly (here: `n == 0 → 0`).
- **Recursive step**: reduce the problem to a smaller one and combine results (here: `n + sumRec(n - 1)`).
- **Progress guarantee**: each call moves toward the base case (here: `n` decreases by 1).
- **Input constraints / assumptions** (optional but useful): e.g., assume `n ≥ 0` or validate input.
